/**
* @file    GvGenericMsg.h
* @brief   Declares the GvGenericMsg class.
*
* Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GV_GENERIC_MSG_H
#define GV_GENERIC_MSG_H

#include <GoVision/Data/GvDataMsg.h>

/**
* Encapsulates a profile message.
*
* @class       GvGenericMsg
* @extends     GvDataMsg
* @ingroup     GoVision-Data
*/
typedef GvDataMsg GvGenericMsg;

/** 
 * Constructs a GvGenericMsg object that contains a kObject.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Receives the constructed object.  
 * @param   alloc       Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
GvFx(kStatus) GvGenericMsg_ConstructObject(GvGenericMsg* msg, kAlloc alloc);

/** 
 * Constructs a GvGenericMsg object that contains a byte buffer.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Receives the constructed object.  
 * @param   bufferSize  Size of the buffer in bytes.
 * @param   alloc       Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
GvFx(kStatus) GvGenericMsg_ConstructBuffer(GvGenericMsg* msg, kSize bufferSize, kAlloc alloc);

/** 
 * Returns the size of the data buffer.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Message object. 
 * @return              Point count.
 */
GvFx(kSize) GvGenericMsg_BufferSize(GvGenericMsg msg);

/** 
 * Copy the object to the message.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Message object. 
 * @param   object      kObject-based object. 
 * @return              Status.
 */
GvFx(kStatus) GvGenericMsg_SetObject(GvGenericMsg msg, kObject object);

/** 
 * Returns the kObject in the message.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Message object. 
 * @return              kObject-based object.
 */
GvFx(kObject) GvGenericMsg_Object(GvGenericMsg msg);

/** 
 * Copy the buffer data to the message.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Message object. 
 * @param   buffer      Pointer to data buffer. 
 * @return              Status.
 */
GvFx(kStatus) GvGenericMsg_SetBuffer(GvGenericMsg msg, void *buffer);

/** 
 * Returns the pointer to data buffer.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Message object. 
 * @return              Data buffer pointer.
 */
GvFx(void *) GvGenericMsg_Buffer(GvGenericMsg msg);

/** 
 * Returns if the data is a kObject type.
 *
 * @public              @memberof GvGenericMsg
 * @param   msg         Message object. 
 * @return              kTRUE if kObject type, kFALSE otherwise.
 */
GvFx(kBool) GvGenericMsg_IsObject(GvGenericMsg msg);

#include <GoVision/Data/GvGenericMsg.x.h>

#endif
