#ifndef GSA_LIB_SENSOR_G2XX_PROPERTIES_H
#define GSA_LIB_SENSOR_G2XX_PROPERTIES_H

#include "SensorBase.h"

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct Tracheid : public GoProp::Structure
{
    GoProp::Value<bool> tracheidExposureEnabled;
    GoProp::Value<k64f> exposure;
    GoProp::Value<k32s> camera0Threshold;
    GoProp::Value<k32s> camera1Threshold;

    Tracheid()
    {
        Register("tracheidExposureEnabled", tracheidExposureEnabled);
        Register("exposure", exposure);

        Register("camera0Threshold", camera0Threshold);
        Register("camera1Threshold", camera1Threshold);
    }
};

struct G2xxSensorSchema : public SensorBase
{
    Tracheid tracheid;

    G2xxSensorSchema()
    {
        Register("tracheid", tracheid);
    }
};

}; // namespaces

#endif
