#ifndef GSA_LIB_SCANNER_G3_PROPERTIES_H
#define GSA_LIB_SCANNER_G3_PROPERTIES_H

#include "ScannerBase.h"
#include "ScannerG2.h"

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct G3Surface : public GoProp::Structure
{
    GoProp::Value<bool> occlusionReductionEnabled;
    GoProp::Value<k32s> occlusionReductionAlg;

    G3Surface()
    {
        Register("OcclusionReductionEnabled", occlusionReductionEnabled);
        Register("OcclusionReductionAlg", occlusionReductionAlg);
    }
};

struct Video : public GoProp::Structure
{
    GoProp::Value<bool> flickerFreeModeEnabled;
    GoProp::Value<bool> flickerFreeModeEnabledUsed;

    Video()
    {
        Register("FlickerFreeModeEnabled", flickerFreeModeEnabled);
        flickerFreeModeEnabled.RegisterSchema("used", flickerFreeModeEnabledUsed);
    }
};

struct G3ScannerSchema : public ScannerBase
{
    Video video;
    G3Surface surface;
    Part part;

    G3ScannerSchema()
    {
        Register("video", video);
        Register("surface", surface);
        Register("part", part);
    }
};

}; // namespaces

#endif
