#ifndef GSA_LIB_SCANNER_G1_PROPERTIES_H
#define GSA_LIB_SCANNER_G1_PROPERTIES_H

#include "ScannerBase.h"

namespace GoSensorApp
{

namespace GoProp = Go::Properties;

struct FixedLength : public GoProp::Structure
{
    GoProp::Value<k32s> startTrigger;
    GoProp::Value<std::vector<k32s>> startTriggerOptions;
    GoProp::Value<k32s> inputIndex;
    GoProp::Value<std::vector<k32s>> inputIndexOptions; // Dynamic options

    FixedLength()
    {
        Register("startTrigger", startTrigger);
        startTriggerOptions.Set({ 0,1,2 });
        startTrigger.RegisterSchema("enum", startTriggerOptions);

        Register("inputIndex", inputIndex);
        inputIndex.RegisterSchema("enum", inputIndexOptions);
    }
};

struct VariableLength : public GoProp::Structure
{
    MinMaxValue<k64f> maxLength;

    VariableLength()
    {
        Register("maxLength", maxLength);
    }
};

struct Rotational : public GoProp::Structure
{
    MinMaxValue<k64f> circumference;

    Rotational()
    {
        Register("circumference", circumference);
    }
};

struct Profile : public GoProp::Structure
{
    GoProp::Value<k32s> type;
    GoProp::Value < std::vector<k32s>> typeOptions;

    FixedLength fixedLength;
    VariableLength variableLength;
    Rotational rotational;

    Profile()
    {
        Register("profileType", type);
        typeOptions.Set({ 0,1,2,3 });
        type.RegisterSchema("enum", typeOptions);

        Register("fixedLength", fixedLength);
        Register("variableLength", variableLength);
        Register("rotational", rotational);
    }
};

struct G1ScannerSchema : public ScannerBase
{
    Profile profile;
    GoProp::Value<bool> profileUsed;

    G1ScannerSchema()
    {
        Register("profile", profile);
        profile.Register("used", profileUsed);
    }
};


}; // namespaces

#endif
