#!/usr/bin/python

import os
import sys

def Generate():

    herePath = os.path.dirname(os.path.realpath(__file__))
    workDir = os.path.normpath(os.path.join(herePath, '..', '..'))
    sys.path.append(workDir)

    print('Generating Gdk Sample solution')
    import Platform.scripts.Utils.kGenerator as generator

    # Generate Visual Studios project to be able to compile for the WIN32/64,
    # Linux X64 platforms and the special Sensor platform.
    # For the Linux X64, this does NOT create make files. It only adds Linux X64
    # as a platform that is selectable from with VS, for development convenience.
    generator.WriteSolution(os.path.join(herePath, '..', 'Gdk.xml'), ['MsvcChooser'], ['Win32', 'Win64', 'Sensor', 'Linux_X64'])

    # Generate make files for C64x & ARM7 platforms.
    generator.WriteSolution(os.path.join(herePath, '..', 'Gdk.xml'), ['Ccs6Mk', 'WrWbMk'], ['C64x', 'Arm7'])

    # Generate make files for Linux X64 and Linux ARM8 platform.
    generator.WriteSolution(os.path.join(herePath, '..', 'Gdk.xml'), ['GnuMk_Linux_Arm64', 'GnuMk_Linux_X64'], ['Linux_Arm64', 'Linux_X64'])

if __name__ == '__main__':
    Generate()
