/** 
 * @file    TestSurfaceFeatures.x.h
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef GDK_SURFACE_FEATURES_TEST_TOOL_X_H
#define GDK_SURFACE_FEATURES_TEST_TOOL_X_H

#include <kVision/S3d/kS3dUtilities.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/L3d/kL3dChartPlotter.h>
#include <kVision/L3d/kL3dLinePalette.h>
#include <kVision/L3d/kL3dUtilities.h>

#define GDK_SURFACE_FEATURES_TEST_TOOL_NAME "TestSurfaceFeatures"
#define GDK_SURFACE_FEATURES_TEST_TOOL_LABEL "Gdk Surface Features Test"

#define GDK_SURFACE_FEATURES_TEST_PARAM_0 "PointX"
#define GDK_SURFACE_FEATURES_TEST_PARAM_1 "PointY"
#define GDK_SURFACE_FEATURES_TEST_PARAM_2 "PointZ"
#define GDK_SURFACE_FEATURES_TEST_PARAM_3 "DirectionX"
#define GDK_SURFACE_FEATURES_TEST_PARAM_4 "DirectionY"
#define GDK_SURFACE_FEATURES_TEST_PARAM_5 "DirectionZ"


typedef struct TestSurfaceFeaturesClass  
{
    GdkToolClass base;
    GdkDataSource dataSource;

    kPoint3d64f lineDirection;
    kPoint3d64f point;


} TestSurfaceFeaturesClass;

kDeclareClassEx(Tool, TestSurfaceFeatures, GdkTool)

ToolFx(const kChar*) TestSurfaceFeatures_VName();
ToolFx(kStatus) TestSurfaceFeatures_VDescribe(GdkToolInfo info);
ToolFx(kStatus) TestSurfaceFeatures_VStart(TestSurfaceFeatures tool);
ToolFx(kStatus) TestSurfaceFeatures_VStop(TestSurfaceFeatures tool);
ToolFx(kStatus) TestSurfaceFeatures_VProcess(TestSurfaceFeatures tool, GdkToolInput input, GdkToolOutput output);
ToolFx(kStatus) TestSurfaceFeatures_VInit(TestSurfaceFeatures tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestSurfaceFeatures_VRelease(TestSurfaceFeatures tool);
ToolFx(kStatus) TestSurfaceFeatures_VNewToolConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestSurfaceFeatures_VNewMeasurementConfig(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
ToolFx(kStatus) TestSurfaceFeatures_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);

ToolFx(kStatus) TestSurfaceFeatures_OutputValue(GdkToolOutput output, kSize index, k64f value, GdkMeasurementDecision decision, GdkToolCfg config);
ToolFx(kStatus) TestSurfaceFeatures_SendFeatureLine(TestSurfaceFeatures tool, GdkToolOutput output, kSize index, kPoint3d64f* linePosition, kPoint3d64f* lineRotations);
ToolFx(kStatus) TestSurfaceFeatures_SendFeaturePoint(TestSurfaceFeatures tool, GdkToolOutput output, kSize index, const kPoint3d64f* ptPosition);

#endif
