/** 
 * @file    TestProfileSelect.x.h
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef TOOL_TEST_PROFILE_SELECT_TOOL_Z_H
#define TOOL_TEST_PROFILE_SELECT_TOOL_Z_H

#define TEST_PROFILE_SELECT_TOOL_NAME        "TestProfileSelectTool"
#define TEST_PROFILE_SELECT_TOOL_LABEL        "Test Profile Select"

typedef enum TestProfileSelectMeasurement
{
    TEST_PROFILE_SELECT_MEASUREMENT_X = 0,
    TEST_PROFILE_SELECT_MEASUREMENT_Z
} TestProfileSelectMeasurement;

typedef struct TestProfileSelectClass 
{
    GdkToolClass base;
    GdkDataSource dataSource;

    kBool useRegion;
    GdkRegionXZ64f region;

    k32u index; // Index to return data
} TestProfileSelectClass;

kDeclareClassEx(Tool, TestProfileSelect, GdkTool)

ToolFx(kStatus) TestProfileSelect_VDescribe(GdkToolInfo info);

ToolFx(kStatus) TestProfileSelect_VInit(TestProfileSelect tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestProfileSelect_VRelease(TestProfileSelect tool);
ToolFx(kStatus) TestProfileSelect_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestProfileSelect_VStart(TestProfileSelect tool);
ToolFx(kStatus) TestProfileSelect_VStop(TestProfileSelect tool);
ToolFx(kStatus) TestProfileSelect_OutputValue(GdkToolCfg config, kSize index, k64f value, GdkMeasurementDecision decision, GdkToolOutput output);
ToolFx(kStatus) TestProfileSelect_VProcess(TestProfileSelect tool, GdkToolInput input, GdkToolOutput output);

#endif
