
export K_REGENERATOR := 1

ifeq ($(OS)$(os), Windows_NT)
	TI_PATH      := C:/ti
	TOOLS_PATH   := C:/tools/GccC64x_4.9.4-p23
	CROSS_PREFIX := C:/tools/GccC64x_4.9.4-p23/tic6x-none-elf/bin/tic6x-none-elf-
	CROSS_SUFFIX := .exe
	PYTHON       := python
else
	TI_PATH      := /ti
	TOOLS_PATH   := /tools/GccC64x_4.9.4-p23
	CROSS_PREFIX := /tools/GccC64x_4.9.4-p23/tic6x-none-elf/bin/tic6x-none-elf-
	CROSS_SUFFIX := 
	PYTHON       := python3
endif

GNU_COMPILER := $(CROSS_PREFIX)gcc$(CROSS_SUFFIX)
GNU_LINKER := $(CROSS_PREFIX)ld$(CROSS_SUFFIX)
GNU_OBJ_NAMES := $(CROSS_PREFIX)nm$(CROSS_SUFFIX)
LINKER := $(CROSS_PREFIX)ld$(CROSS_SUFFIX)
ARCHIVER := $(CROSS_PREFIX)ar$(CROSS_SUFFIX)
OBJ_NAMES := $(CROSS_PREFIX)nm$(CROSS_SUFFIX)
XDC_XS := $(TI_PATH)/xdctools_3_31_00_24_core/xs$(CROSS_SUFFIX)

AIS := $(PYTHON) ../../Platform/scripts/Utils/kAis.py
MUNCH := $(PYTHON) ../../Platform/scripts/Utils/kCrunch.py
MKDIR_P := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py mkdir_p
RM_F := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py rm_f
RM_RF := $(PYTHON) ../../Platform/scripts/Utils/kUtil.py rm_rf
KGENERATOR := $(PYTHON) ../../Platform/scripts/Utils/kGenerator.py

ifndef verbose
	SILENT := @
endif

ifndef config
	config := Debug
endif

# We require tools to be installed according to specific conventions (see manuals).
# Tool prerequisites may change between major releases; check and report.
ifeq ($(shell $(GNU_COMPILER) --version),)
.PHONY: tc_err
tc_err:
	$(error Cannot build because of missing prerequisite; please install)
endif

ifeq ($(config),Debug)

	TARGET := ../../bin/c64x/GdkAppSampleDm647.kapp
	INTERMEDIATES := ../../bin/c64x/GdkAppSampleDm647.out
	OBJ_DIR := ../../build/GdkAppSample-ccs6mk-Debug
	PREBUILD := 
	POSTBUILD := 
	TI_COMPILER := $(TI_PATH)/cgtools_7.4.13/bin/cl6x$(CROSS_SUFFIX)
	TI_LINKER := $(TI_PATH)/cgtools_7.4.13/bin/lnk6x$(CROSS_SUFFIX)
	TI_ARCHIVER := $(TI_PATH)/cgtools_7.4.13/bin/ar6x$(CROSS_SUFFIX)
	TI_OFDISP := $(TI_PATH)/cgtools_7.4.13/bin/ofd6x$(CROSS_SUFFIX)
	TI_COMPILER_FLAGS := -o3 -mv6400+ --abi=eabi -mi1 --mem_model:data=far -q
	TI_COMPILER_C_FLAGS := -pr -pdr -pden -pds179 -pds190 -pds195 -pds238 -pds552 -pds880 -pds1628 -pds2142 -pds2709
	TI_COMPILER_CXX_FLAGS := -pr -pden -pds179 --exceptions
	TI_COMPILER_DEFINES := -DGDKAPP
	TI_COMPILER_INCLUDE_DIRS := -I$(TI_PATH)/bios_6_42_03_35/packages -I$(TI_PATH)/xdctools_3_31_00_24_core/packages -I$(TI_PATH)/cgtools_7.4.13/include -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	TI_LINKER_FLAGS := -q -a -c -x --diag_suppress=10189 --diag_suppress=16002 --diag_suppress=10068
	TI_LIB_DIRS := -i$(TI_PATH)/cgtools_7.4.13/lib -i$(TOOLS_PATH)/tic6x-none-elf/lib/gcc/tic6x-none-elf/4.9.4 -i$(TOOLS_PATH)/tic6x-none-elf/tic6x-none-elf/lib -i../../lib/c64x -i../../Platform/extern/Ti/FastRts/c6400/mthlib/lib -i../../Platform/kHardware/kHardware/Dm647/Tcf -i../../Platform/kHardwareDm647/kHardwareDm647/Tcf
	TI_LIBS := -lkApi.lib -lkFireSync.lib -lkHardwareDm647.lib -lkVision.lib -lfastrts64x.lib -lGdk.lib -lGoCommon.lib -lGoVision.lib -lGoTools.lib -lGoSensor.lib -lGoApi.lib -lGoSensorAppLib.lib -lGoPipe.lib -lGoPlugin.lib -lGoRest.lib -llibgccmin.a -llibstdc++.a -llibcmin.a ../../Platform/kHardwareDm647/kHardwareDm647/Tcf/kHwDm647.cmd
	GNU_COMPILER_FLAGS := -O2 -fno-partial-inlining -fno-reorder-functions -march=c64x+ -msdata=none -ffunction-sections -fdata-sections
	GNU_COMPILER_C_FLAGS := -std=gnu99 -Wall -Wfloat-conversion -Wno-missing-braces -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value
	GNU_COMPILER_CXX_FLAGS := -std=c++14 -fexceptions -Wall -Wfloat-conversion -Wno-missing-braces
	GNU_COMPILER_DEFINES := -DGDKAPP -Dxdc_target_types__=../../Platform/extern/Ti/xdc/xdc_gcc.h
	GNU_COMPILER_INCLUDE_DIRS := -I$(TI_PATH)/bios_6_42_03_35/packages -I$(TI_PATH)/xdctools_3_31_00_24_core/packages -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	GNU_LINKER_FLAGS := -X -EL -r -nostdlib --allow-multiple-definition --whole-archive
	GNU_LIB_DIRS := -L$(TI_PATH)/cgtools_7.4.13/lib -L$(TOOLS_PATH)/tic6x-none-elf/lib/gcc/tic6x-none-elf/4.9.4 -L$(TOOLS_PATH)/tic6x-none-elf/tic6x-none-elf/lib -L../../lib/c64x -L../../Platform/extern/Ti/FastRts/c6400/mthlib/lib -L../../Platform/kHardware/kHardware/Dm647/Tcf
	GNU_LIBS := -l:kApi.lib -l:kFireSync.lib -l:kHardwareDm647.lib -l:kVision.lib -l:fastrts64x.lib -l:Gdk.lib -l:GoCommon.lib -l:GoVision.lib -l:GoTools.lib -l:GoSensor.lib -l:GoApi.lib -l:GoSensorAppLib.lib -l:GoPipe.lib -l:GoPlugin.lib -l:GoRest.lib -lgccmin -lstdc++ -lcmin
	OBJECTS := ../../build/GdkAppSample-ccs6mk-Debug/Asm.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestProfileSelect.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestMesh.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceSelect.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceConfiguration.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceGraphics.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceFeatures.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestFeatureAverage.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceDynamicAlignment.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestProfileDynamicAlignment.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestDynamicOutputs.obj \
	../../build/GdkAppSample-ccs6mk-Debug/TestGenericInput.obj \
	../../build/GdkAppSample-ccs6mk-Debug/GdkPartSegmentResult.obj
	XS_FILES := 
	DEP_FILES := ../../build/GdkAppSample-ccs6mk-Debug/Asm.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestProfileSelect.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestMesh.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceSelect.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceConfiguration.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceGraphics.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceFeatures.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestFeatureAverage.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceDynamicAlignment.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestProfileDynamicAlignment.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestDynamicOutputs.d \
	../../build/GdkAppSample-ccs6mk-Debug/TestGenericInput.d \
	../../build/GdkAppSample-ccs6mk-Debug/GdkPartSegmentResult.d
	TARGET_DEPS := 

endif

ifeq ($(config),Release)

	TARGET := ../../bin/c64x/GdkAppSampleDm647.kapp
	INTERMEDIATES := ../../bin/c64x/GdkAppSampleDm647.out
	OBJ_DIR := ../../build/GdkAppSample-ccs6mk-Release
	PREBUILD := 
	POSTBUILD := 
	TI_COMPILER := $(TI_PATH)/cgtools_7.4.13/bin/cl6x$(CROSS_SUFFIX)
	TI_LINKER := $(TI_PATH)/cgtools_7.4.13/bin/lnk6x$(CROSS_SUFFIX)
	TI_ARCHIVER := $(TI_PATH)/cgtools_7.4.13/bin/ar6x$(CROSS_SUFFIX)
	TI_OFDISP := $(TI_PATH)/cgtools_7.4.13/bin/ofd6x$(CROSS_SUFFIX)
	TI_COMPILER_FLAGS := -o3 -mv6400+ --abi=eabi -mi1 --mem_model:data=far -q
	TI_COMPILER_C_FLAGS := -pr -pdr -pden -pds179 -pds190 -pds195 -pds238 -pds552 -pds880 -pds1628 -pds2142 -pds2709
	TI_COMPILER_CXX_FLAGS := -pr -pden -pds179 --exceptions
	TI_COMPILER_DEFINES := -DGDKAPP
	TI_COMPILER_INCLUDE_DIRS := -I$(TI_PATH)/bios_6_42_03_35/packages -I$(TI_PATH)/xdctools_3_31_00_24_core/packages -I$(TI_PATH)/cgtools_7.4.13/include -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	TI_LINKER_FLAGS := -q -a -c -x --diag_suppress=10189 --diag_suppress=16002 --diag_suppress=10068
	TI_LIB_DIRS := -i$(TI_PATH)/cgtools_7.4.13/lib -i$(TOOLS_PATH)/tic6x-none-elf/lib/gcc/tic6x-none-elf/4.9.4 -i$(TOOLS_PATH)/tic6x-none-elf/tic6x-none-elf/lib -i../../lib/c64x -i../../Platform/extern/Ti/FastRts/c6400/mthlib/lib -i../../Platform/kHardware/kHardware/Dm647/Tcf -i../../Platform/kHardwareDm647/kHardwareDm647/Tcf
	TI_LIBS := -lkApi.lib -lkFireSync.lib -lkHardwareDm647.lib -lkVision.lib -lfastrts64x.lib -lGdk.lib -lGoCommon.lib -lGoVision.lib -lGoTools.lib -lGoSensor.lib -lGoApi.lib -lGoSensorAppLib.lib -lGoPipe.lib -lGoPlugin.lib -lGoRest.lib -llibgccmin.a -llibstdc++.a -llibcmin.a ../../Platform/kHardwareDm647/kHardwareDm647/Tcf/kHwDm647.cmd
	GNU_COMPILER_FLAGS := -O2 -fno-partial-inlining -fno-reorder-functions -march=c64x+ -msdata=none -ffunction-sections -fdata-sections
	GNU_COMPILER_C_FLAGS := -std=gnu99 -Wall -Wfloat-conversion -Wno-missing-braces -Wno-unused-variable -Wno-unused-parameter -Wno-unused-value
	GNU_COMPILER_CXX_FLAGS := -std=c++14 -fexceptions -Wall -Wfloat-conversion -Wno-missing-braces
	GNU_COMPILER_DEFINES := -DGDKAPP -Dxdc_target_types__=../../Platform/extern/Ti/xdc/xdc_gcc.h
	GNU_COMPILER_INCLUDE_DIRS := -I$(TI_PATH)/bios_6_42_03_35/packages -I$(TI_PATH)/xdctools_3_31_00_24_core/packages -I. -I../../Platform/kApi -I../../Platform/kFireSync -I../../Platform/kHardware -I../../Platform/kVision -I../Gdk -I../GoVision -I../GoSensor -I../GoSensorApp
	GNU_LINKER_FLAGS := -X -EL -r -nostdlib --allow-multiple-definition --whole-archive
	GNU_LIB_DIRS := -L$(TI_PATH)/cgtools_7.4.13/lib -L$(TOOLS_PATH)/tic6x-none-elf/lib/gcc/tic6x-none-elf/4.9.4 -L$(TOOLS_PATH)/tic6x-none-elf/tic6x-none-elf/lib -L../../lib/c64x -L../../Platform/extern/Ti/FastRts/c6400/mthlib/lib -L../../Platform/kHardware/kHardware/Dm647/Tcf
	GNU_LIBS := -l:kApi.lib -l:kFireSync.lib -l:kHardwareDm647.lib -l:kVision.lib -l:fastrts64x.lib -l:Gdk.lib -l:GoCommon.lib -l:GoVision.lib -l:GoTools.lib -l:GoSensor.lib -l:GoApi.lib -l:GoSensorAppLib.lib -l:GoPipe.lib -l:GoPlugin.lib -l:GoRest.lib -lgccmin -lstdc++ -lcmin
	OBJECTS := ../../build/GdkAppSample-ccs6mk-Release/Asm.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestProfileSelect.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestMesh.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceSelect.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceConfiguration.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceGraphics.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceFeatures.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestFeatureAverage.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceDynamicAlignment.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestProfileDynamicAlignment.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestDynamicOutputs.obj \
	../../build/GdkAppSample-ccs6mk-Release/TestGenericInput.obj \
	../../build/GdkAppSample-ccs6mk-Release/GdkPartSegmentResult.obj
	XS_FILES := 
	DEP_FILES := ../../build/GdkAppSample-ccs6mk-Release/Asm.d \
	../../build/GdkAppSample-ccs6mk-Release/TestProfileSelect.d \
	../../build/GdkAppSample-ccs6mk-Release/TestMesh.d \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceSelect.d \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceConfiguration.d \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceGraphics.d \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceFeatures.d \
	../../build/GdkAppSample-ccs6mk-Release/TestFeatureAverage.d \
	../../build/GdkAppSample-ccs6mk-Release/TestSurfaceDynamicAlignment.d \
	../../build/GdkAppSample-ccs6mk-Release/TestProfileDynamicAlignment.d \
	../../build/GdkAppSample-ccs6mk-Release/TestDynamicOutputs.d \
	../../build/GdkAppSample-ccs6mk-Release/TestGenericInput.d \
	../../build/GdkAppSample-ccs6mk-Release/GdkPartSegmentResult.d
	TARGET_DEPS := 

endif

.PHONY: all all-obj all-dep

all: $(OBJ_DIR)
	$(PREBUILD)
	$(SILENT) $(MAKE) -f GdkAppSample-Ccs6.mk all-dep
	$(SILENT) $(MAKE) -f GdkAppSample-Ccs6.mk all-obj

clean:
	$(info Cleaning $(OBJ_DIR))
	$(SILENT) $(RM_RF) $(OBJ_DIR)
	$(info Cleaning $(TARGET) $(INTERMEDIATES))
	$(SILENT) $(RM_F) $(TARGET) $(INTERMEDIATES)

all-obj: $(OBJ_DIR) $(TARGET)
all-dep: $(OBJ_DIR) $(DEP_FILES)

$(OBJ_DIR): GdkAppSample-Ccs6.mk
	$(info Cleanse $(OBJ_DIR))
	$(SILENT) $(RM_RF) $(OBJ_DIR)
	$(SILENT) $(MKDIR_P) $(OBJ_DIR)

ifeq ($(MAKECMDGOALS),)
ifeq ($(MAKE_RESTARTS),)
GdkAppSample-Ccs6.mk: GdkAppSample.xml ../Gdk.xml ../../Platform/scripts/Utils/Generator/Ccs6Mk.py
	$(info RegenC64x GdkAppSample-Ccs6.mk)
	$(SILENT) $(KGENERATOR) --writers=Ccs6Mk --platforms=C64x --project=GdkAppSample ../Gdk.xml
endif
endif

ifeq ($(config),Debug)

../../bin/c64x/GdkAppSampleDm647.kapp: ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSampleDm647.xml ../../bin/c64x/GdkAppSampleDm647.out
	$(info AisC64x ../../bin/c64x/GdkAppSampleDm647.kapp)
	$(SILENT) $(AIS) ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSampleDm647.xml ../../bin/c64x/GdkAppSampleDm647.out ../../bin/c64x/GdkAppSampleDm647.kapp
	$(POSTBUILD)

../../build/GdkAppSample-ccs6mk-Debug/GdkAppSampleDm647.xml: ../../bin/c64x/GdkAppSampleDm647.out
	$(info OfdC64x ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSampleDm647.xml)
	$(SILENT) $(TI_OFDISP) -x --obj_display=none,header,optheader,sections,symbols ../../bin/c64x/GdkAppSampleDm647.out > ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSampleDm647.xml

../../bin/c64x/GdkAppSampleDm647.out: $(OBJECTS) $(TARGET_DEPS) ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.o
	$(info TiClrC64x ../../bin/c64x/GdkAppSampleDm647.out)
	$(SILENT) $(TI_LINKER) $(TI_LINKER_FLAGS) -o../../bin/c64x/GdkAppSampleDm647.out -m../../build/GdkAppSample-ccs6mk-Debug/GdkAppSampleDm647.map $(TI_LIB_DIRS) $(TI_LIBS) $(OBJECTS) ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.o

../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.o: ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.c
	$(info GccC64x ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.c)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_C_FLAGS) -o ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.o -c ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.c -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.c: ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-partial.o
	$(info MunchC64x ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.c)
	$(SILENT) $(MUNCH) $(GNU_OBJ_NAMES) ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-partial.o ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-munch.c

../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-partial.o: $(OBJECTS) $(TARGET_DEPS)
	$(info LdC64x ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-partial.o)
	$(SILENT) $(GNU_LINKER) $(GNU_LIB_DIRS) $(GNU_LINKER_FLAGS) -o ../../build/GdkAppSample-ccs6mk-Debug/GdkAppSample-partial.o $(OBJECTS) $(GNU_LIBS)

endif

ifeq ($(config),Release)

../../bin/c64x/GdkAppSampleDm647.kapp: ../../build/GdkAppSample-ccs6mk-Release/GdkAppSampleDm647.xml ../../bin/c64x/GdkAppSampleDm647.out
	$(info AisC64x ../../bin/c64x/GdkAppSampleDm647.kapp)
	$(SILENT) $(AIS) ../../build/GdkAppSample-ccs6mk-Release/GdkAppSampleDm647.xml ../../bin/c64x/GdkAppSampleDm647.out ../../bin/c64x/GdkAppSampleDm647.kapp
	$(POSTBUILD)

../../build/GdkAppSample-ccs6mk-Release/GdkAppSampleDm647.xml: ../../bin/c64x/GdkAppSampleDm647.out
	$(info OfdC64x ../../build/GdkAppSample-ccs6mk-Release/GdkAppSampleDm647.xml)
	$(SILENT) $(TI_OFDISP) -x --obj_display=none,header,optheader,sections,symbols ../../bin/c64x/GdkAppSampleDm647.out > ../../build/GdkAppSample-ccs6mk-Release/GdkAppSampleDm647.xml

../../bin/c64x/GdkAppSampleDm647.out: $(OBJECTS) $(TARGET_DEPS) ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.o
	$(info TiClrC64x ../../bin/c64x/GdkAppSampleDm647.out)
	$(SILENT) $(TI_LINKER) $(TI_LINKER_FLAGS) -o../../bin/c64x/GdkAppSampleDm647.out -m../../build/GdkAppSample-ccs6mk-Release/GdkAppSampleDm647.map $(TI_LIB_DIRS) $(TI_LIBS) $(OBJECTS) ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.o

../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.o: ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.c
	$(info GccC64x ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.c)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_C_FLAGS) -o ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.o -c ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.c -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.c: ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-partial.o
	$(info MunchC64x ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.c)
	$(SILENT) $(MUNCH) $(GNU_OBJ_NAMES) ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-partial.o ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-munch.c

../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-partial.o: $(OBJECTS) $(TARGET_DEPS)
	$(info LdC64x ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-partial.o)
	$(SILENT) $(GNU_LINKER) $(GNU_LIB_DIRS) $(GNU_LINKER_FLAGS) -o ../../build/GdkAppSample-ccs6mk-Release/GdkAppSample-partial.o $(OBJECTS) $(GNU_LIBS)

endif

ifeq ($(config),Debug)

../../build/GdkAppSample-ccs6mk-Debug/Asm.obj ../../build/GdkAppSample-ccs6mk-Debug/Asm.d: GdkAppSample/Asm.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/Asm.obj -c GdkAppSample/Asm.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestProfileSelect.obj ../../build/GdkAppSample-ccs6mk-Debug/TestProfileSelect.d: GdkAppSample/TestProfileSelect.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestProfileSelect.obj -c GdkAppSample/TestProfileSelect.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestMesh.obj ../../build/GdkAppSample-ccs6mk-Debug/TestMesh.d: GdkAppSample/TestMesh.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestMesh.obj -c GdkAppSample/TestMesh.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceSelect.obj ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceSelect.d: GdkAppSample/TestSurfaceSelect.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceSelect.obj -c GdkAppSample/TestSurfaceSelect.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceConfiguration.obj ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceConfiguration.d: GdkAppSample/TestSurfaceConfiguration.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceConfiguration.obj -c GdkAppSample/TestSurfaceConfiguration.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceGraphics.obj ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceGraphics.d: GdkAppSample/TestSurfaceGraphics.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceGraphics.obj -c GdkAppSample/TestSurfaceGraphics.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceFeatures.obj ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceFeatures.d: GdkAppSample/TestSurfaceFeatures.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceFeatures.obj -c GdkAppSample/TestSurfaceFeatures.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestFeatureAverage.obj ../../build/GdkAppSample-ccs6mk-Debug/TestFeatureAverage.d: GdkAppSample/TestFeatureAverage.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestFeatureAverage.obj -c GdkAppSample/TestFeatureAverage.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceDynamicAlignment.obj ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceDynamicAlignment.d: GdkAppSample/TestSurfaceDynamicAlignment.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceDynamicAlignment.obj -c GdkAppSample/TestSurfaceDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestProfileDynamicAlignment.obj ../../build/GdkAppSample-ccs6mk-Debug/TestProfileDynamicAlignment.d: GdkAppSample/TestProfileDynamicAlignment.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestProfileDynamicAlignment.obj -c GdkAppSample/TestProfileDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestDynamicOutputs.obj ../../build/GdkAppSample-ccs6mk-Debug/TestDynamicOutputs.d: GdkAppSample/TestDynamicOutputs.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestDynamicOutputs.obj -c GdkAppSample/TestDynamicOutputs.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/TestGenericInput.obj ../../build/GdkAppSample-ccs6mk-Debug/TestGenericInput.d: GdkAppSample/TestGenericInput.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/TestGenericInput.obj -c GdkAppSample/TestGenericInput.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Debug/GdkPartSegmentResult.obj ../../build/GdkAppSample-ccs6mk-Debug/GdkPartSegmentResult.d: GdkAppSample/GdkPartSegmentResult.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Debug/GdkPartSegmentResult.obj -c GdkAppSample/GdkPartSegmentResult.cpp -MMD -MP

endif

ifeq ($(config),Release)

../../build/GdkAppSample-ccs6mk-Release/Asm.obj ../../build/GdkAppSample-ccs6mk-Release/Asm.d: GdkAppSample/Asm.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/Asm.obj -c GdkAppSample/Asm.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestProfileSelect.obj ../../build/GdkAppSample-ccs6mk-Release/TestProfileSelect.d: GdkAppSample/TestProfileSelect.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestProfileSelect.obj -c GdkAppSample/TestProfileSelect.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestMesh.obj ../../build/GdkAppSample-ccs6mk-Release/TestMesh.d: GdkAppSample/TestMesh.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestMesh.obj -c GdkAppSample/TestMesh.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestSurfaceSelect.obj ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceSelect.d: GdkAppSample/TestSurfaceSelect.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceSelect.obj -c GdkAppSample/TestSurfaceSelect.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestSurfaceConfiguration.obj ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceConfiguration.d: GdkAppSample/TestSurfaceConfiguration.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceConfiguration.obj -c GdkAppSample/TestSurfaceConfiguration.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestSurfaceGraphics.obj ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceGraphics.d: GdkAppSample/TestSurfaceGraphics.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceGraphics.obj -c GdkAppSample/TestSurfaceGraphics.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestSurfaceFeatures.obj ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceFeatures.d: GdkAppSample/TestSurfaceFeatures.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceFeatures.obj -c GdkAppSample/TestSurfaceFeatures.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestFeatureAverage.obj ../../build/GdkAppSample-ccs6mk-Release/TestFeatureAverage.d: GdkAppSample/TestFeatureAverage.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestFeatureAverage.obj -c GdkAppSample/TestFeatureAverage.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestSurfaceDynamicAlignment.obj ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceDynamicAlignment.d: GdkAppSample/TestSurfaceDynamicAlignment.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceDynamicAlignment.obj -c GdkAppSample/TestSurfaceDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestProfileDynamicAlignment.obj ../../build/GdkAppSample-ccs6mk-Release/TestProfileDynamicAlignment.d: GdkAppSample/TestProfileDynamicAlignment.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestProfileDynamicAlignment.obj -c GdkAppSample/TestProfileDynamicAlignment.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestDynamicOutputs.obj ../../build/GdkAppSample-ccs6mk-Release/TestDynamicOutputs.d: GdkAppSample/TestDynamicOutputs.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestDynamicOutputs.obj -c GdkAppSample/TestDynamicOutputs.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/TestGenericInput.obj ../../build/GdkAppSample-ccs6mk-Release/TestGenericInput.d: GdkAppSample/TestGenericInput.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/TestGenericInput.obj -c GdkAppSample/TestGenericInput.cpp -MMD -MP

../../build/GdkAppSample-ccs6mk-Release/GdkPartSegmentResult.obj ../../build/GdkAppSample-ccs6mk-Release/GdkPartSegmentResult.d: GdkAppSample/GdkPartSegmentResult.cpp
	$(info GccC64x $<)
	$(SILENT) $(GNU_COMPILER) $(GNU_COMPILER_FLAGS) $(GNU_COMPILER_CXX_FLAGS) $(GNU_COMPILER_DEFINES) $(GNU_COMPILER_INCLUDE_DIRS) -o ../../build/GdkAppSample-ccs6mk-Release/GdkPartSegmentResult.obj -c GdkAppSample/GdkPartSegmentResult.cpp -MMD -MP

endif

ifeq ($(MAKECMDGOALS),all-obj)

ifeq ($(config),Debug)

include ../../build/GdkAppSample-ccs6mk-Debug/Asm.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestProfileSelect.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestMesh.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceSelect.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceConfiguration.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceGraphics.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceFeatures.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestFeatureAverage.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestSurfaceDynamicAlignment.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestProfileDynamicAlignment.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestDynamicOutputs.d
include ../../build/GdkAppSample-ccs6mk-Debug/TestGenericInput.d
include ../../build/GdkAppSample-ccs6mk-Debug/GdkPartSegmentResult.d

endif

ifeq ($(config),Release)

include ../../build/GdkAppSample-ccs6mk-Release/Asm.d
include ../../build/GdkAppSample-ccs6mk-Release/TestProfileSelect.d
include ../../build/GdkAppSample-ccs6mk-Release/TestMesh.d
include ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceSelect.d
include ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceConfiguration.d
include ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceGraphics.d
include ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceFeatures.d
include ../../build/GdkAppSample-ccs6mk-Release/TestFeatureAverage.d
include ../../build/GdkAppSample-ccs6mk-Release/TestSurfaceDynamicAlignment.d
include ../../build/GdkAppSample-ccs6mk-Release/TestProfileDynamicAlignment.d
include ../../build/GdkAppSample-ccs6mk-Release/TestDynamicOutputs.d
include ../../build/GdkAppSample-ccs6mk-Release/TestGenericInput.d
include ../../build/GdkAppSample-ccs6mk-Release/GdkPartSegmentResult.d

endif

endif

