#ifndef GDK_UTILS_H
#define GDK_UTILS_H

#include <Gdk/GdkDef.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kString.h>

#define GDK_UTILS_STREAM_ID_SEPARATOR  "-"

GdkFx(kStatus) GdkUtils_FormatCsv(kArrayList list, kString str);
GdkFx(kStatus) GdkUtils_ParseCsv(kArrayList list, const kChar* text);
GdkFx(kStatus) GdkUtils_ParseStreamId(kString str, GdkStreamId* streamId, kAlloc alloc);
GdkFx(k32s) GdkUtils_Serialize32FWithPrecision(k32f val,k32u precision);
GdkFx(k64s) GdkUtils_Serialize64FWithPrecision(k64f val, k64u precision);
GdkFx(kStatus) GdkUtils_ApplyAnchorToRegion3d(const GdkRegion3d64f* regionIn,
    k64f anchorX, k64f anchorY, k64f anchorZ, k64f anchorZAngle,
    GdkRegion3d64f* anchoredRegion);
GdkFx(kStatus) GdkUtils_PointSetRegionBoundingBox(const kArrayList *points, GdkRegion3d64f *boundingBox);
GdkFx(kStatus) GdkUtils_ApplyXYAnchorToPointSetRegion(const kPoint3d64f* anchor, const kArrayList* inputPoints, kArrayList* outputPoints);
GdkFx(kStatus) GdkUtils_ApplyXYZAngleAnchorToPointSetRegion(k64f anchorZAngle, const kPoint3d64f* anchorPosition, const kArrayList* inputPoints, kArrayList* outputPoints);
GdkFx(kStatus) GdkUtils_ApplyZAngleAnchorToPointSetRegion(k64f anchorZAngle, const kPoint3d64f* anchorPosition, const kArrayList* inputPoints, kArrayList* outputPoints);
GdkFx(kStatus) GdkUtils_RotatePointPosition(k64f angle, const kPoint3d64f* cor, const kPoint3d64f* inputPoint, kPoint3d64f* outputPoint);
GdkFx(kStatus) GdkUtils_RotatePointsXY(k64f angle, const kPoint3d64f* cor, const kArrayList* inputPoints, kArrayList* outputPoints);

GdkFx(kStatus) GdkUtils_ValidateNoSpecialChars(const kChar* str);

#endif
