#ifndef GDK_TOOL_X_H
#define GDK_TOOL_X_H

#include <kApi/kObject.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kMap.h>
#include <kApi/Data/kString.h>
#include <Gdk/Config/GdkToolCfg.h>
#include <Gdk/Utils/GdkUtils.h>

typedef struct GdkToolVTable
{
    kObjectVTable base;
    const kChar* (kCall* VName)();
    kStatus (kCall* VDescribe)(GdkToolInfo info);
    kStatus (kCall* VInit)(GdkTool info, kType type, kAlloc alloc);

    // Deprecated. Use VNewToolConfigInstanced.
    kStatus (kCall* VNewToolConfig)(const GdkToolEnv* env, GdkToolCfg toolConfig);
    // Deprecated. Use VNewMeasurementConfigInstanced.
    kStatus (kCall* VNewMeasurementConfig)(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
    // Deprecated. Use VNewFeatureConfigInstanced.
    kStatus (kCall* VNewFeatureConfig)(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkFeatureCfg featureConfig);
    // Deprecated.  Use VNewToolDataOutputConfigInstanced.
    kStatus (kCall* VNewToolDataOutputConfig)(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkToolDataOutputCfg toolDataOutputConfig);
    // Deprecated. Use VUpdateConfigInstanced.
    kStatus (kCall* VUpdateConfig)(const GdkToolEnv* env, GdkToolCfg toolConfig);
    // Deprecated. Use VCalcDataOutputRegionInstanced.
    kStatus (kCall* VCalcDataOutputRegion)(const GdkToolEnv* env, GdkToolCfg toolConfig, GdkToolDataOutputCfg outputConfig, GdkRegion3d64f* region);

    // This API is applicable to a tool type and not applicable to a specific tool instance.
    // Therefore this API is still valid and is NOT deprecated.
    kBool(kCall* VIsVisible)(const GdkToolEnv* env);

    kStatus (kCall* VStart)(GdkTool tool);
    kStatus (kCall* VStop)(GdkTool tool);
    kStatus (kCall* VProcess)(GdkTool tool, GdkToolInput input, GdkToolOutput output);

    // New GDK instance APIs to replace the deprecated static APIs above.
    kStatus(kCall* VNewToolConfigInstanced)(GdkTool tool, GdkToolCfg toolConfig);
    kStatus(kCall* VNewMeasurementConfigInstanced)(GdkTool tool, GdkMeasurementCfg measurementConfig);
    kStatus(kCall* VNewFeatureConfigInstanced)(GdkTool tool, GdkFeatureCfg featureConfig);
    kStatus(kCall* VNewToolDataOutputConfigInstanced)(GdkTool tool, GdkToolDataOutputCfg toolDataOutputConfig);
    kStatus(kCall* VUpdateConfigInstanced)(GdkTool tool, GdkToolCfg toolConfig);
    kStatus(kCall* VCalcDataOutputRegionInstanced)(GdkTool tool, GdkToolDataOutputCfg outputConfig, GdkRegion3d64f* region);
} GdkToolVTable;

typedef struct GdkToolClass
{
    kObjectClass base;

    // This is owned by the framework. Do not destroy.
    GdkToolCfg config;

    // The tool manager sets the sensor info to the global sensor info object.
    // the tool block switches the sensor info to a tool instance specific
    // sensor info object.
    GdkSensorInfo sensorInfo;

    kMap inputDataNameToIndexMap;
    k32s id;

    kBool diagnosticsRouted;

    GdkToolInput currentInput;

    // This is a handle to the tool block which contains this GDK tool.
    kPxBlock toolBlock;
} GdkToolClass;

kDeclareVirtualClassEx(Gdk, GdkTool, kObject)

GdkFx(const kChar*) GdkTool_VName();
GdkFx(kStatus) GdkTool_VDescribe(GdkToolInfo info);

GdkFx(kStatus) GdkTool_VInit(GdkTool tool, kType type, kAlloc allocator);
GdkFx(kStatus) GdkTool_VRelease(GdkTool tool);

// Called by the framework

GdkFx(kStatus) GdkTool_EnumerateTypes(kArrayList types);
GdkFx(const kChar*) GdkTool_Name(kType type);
GdkFx(kStatus) GdkTool_Describe(kType type, GdkToolInfo info);

GdkFx(kStatus) GdkTool_InitToolConfig(kType type, const GdkToolEnv* env, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkTool_InitMeasurementConfig(kType type, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
GdkFx(kStatus) GdkTool_InitFeatureConfig(kType type, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkFeatureCfg featureConfig);
GdkFx(kStatus) GdkTool_InitToolDataOutputConfig(kType type, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkToolDataOutputCfg toolDataOutputConfig);
GdkFx(kStatus) GdkTool_OnUpdateConfig(kType type, const GdkToolEnv* env, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkTool_CalcDataOutputRegion(kType type, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkToolDataOutputCfg outputConfig, GdkRegion3d64f* region);
GdkFx(kBool) GdkTool_IsVisible(kType type, const GdkToolEnv* env);

GdkFx(kStatus) GdkTool_InitToolConfigInstanced(GdkTool tool, const GdkToolEnv* env, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkTool_InitMeasurementConfigInstanced(GdkTool tool, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkMeasurementCfg measurementConfig);
GdkFx(kStatus) GdkTool_InitFeatureConfigInstanced(GdkTool tool, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkFeatureCfg featureConfig);
GdkFx(kStatus) GdkTool_InitToolDataOutputConfigInstanced(GdkTool tool, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkToolDataOutputCfg toolDataOutputConfig);
GdkFx(kStatus) GdkTool_OnUpdateConfigInstanced(GdkTool tool, const GdkToolEnv* env, GdkToolCfg toolConfig);
GdkFx(kStatus) GdkTool_CalcDataOutputRegionInstanced(GdkTool tool, const GdkToolEnv* env, GdkToolCfg toolConfig, GdkToolDataOutputCfg outputConfig, GdkRegion3d64f* region);

GdkFx(kStatus) GdkTool_Construct(GdkTool* tool, kType type, kAlloc alloc);

GdkFx(kStatus) GdkTool_Init(GdkTool tool, kType type, kAlloc allocator);

GdkFx(kStatus) GdkTool_SetConfig(GdkTool tool, GdkToolCfg config);
GdkFx(kStatus) GdkTool_SetSensorInfo(GdkTool tool, GdkSensorInfo info);
GdkFx(k32s) GdkTool_ToolId(GdkTool tool);
GdkFx(kStatus) GdkTool_SetToolId(GdkTool tool, k32s id);

GdkFx(kStatus) GdkTool_AddInputDataMap(GdkTool tool, kString* nameStr, kSize* index);
GdkFx(kStatus) GdkTool_PurgeInputDataMap(GdkTool tool);

GdkFx(kStatus) GdkTool_Start(GdkTool tool);
GdkFx(kStatus) GdkTool_Stop(GdkTool tool);
GdkFx(kStatus) GdkTool_Process(GdkTool tool, GdkToolInput input, GdkToolOutput output);
GdkFx(kStatus) GdkTool_Run(GdkTool tool, GdkToolInput input, GdkToolOutput output);

GdkFx(kStatus) GdkTool_SetDiagnosticsRouted(GdkTool tool, kBool enable);

GdkFx(kStatus) GdkTool_DrawAnchorPoints(GdkTool tool, GdkToolInput input, GdkToolOutput output);

GdkFx(kStatus) GdkTool_AddGraphicItemToOutputs(GdkTool tool, GdkToolOutput output, kObject graphicItem);

GdkFx(kStatus) GdkTool_ApplyAnchorToRegionXZ(GdkTool tool, GdkToolInput input, const GdkRegionXZ64f* originalRegion, GdkRegionXZ64f* newRegion);
GdkFx(kStatus) GdkTool_ApplyAnchorToRegion3d(GdkTool tool, GdkToolInput input, const GdkRegion3d64f* originalRegion, GdkRegion3d64f* newRegion);
GdkFx(kStatus) GdkTool_ApplyAnchorToPointSetRegion(GdkTool tool, GdkToolInput input, const kArrayList* originalRegion, kArrayList* newRegion);

GdkFx(kStatus) GdkTool_SetupForConfig(GdkTool tool, const GdkToolEnv* env, GdkToolCfg toolConfig);

/**
* Returns true if this tool has any routed diagnostic outputs.
*
* @public               @memberof GdkTool
* @param   tool         Tool object.
* @return               if this tool has any routed diagnostic outputs.
*/
GdkFx(kBool) GdkTool_DiagnosticsRouted(GdkTool tool);

// This function is called internally by GsToolBlock to give the GDK tool a handle
// to the tool block which encapsulates/contains the GDK tool. The GDK tool code
// should never access the tool block directly.
GdkFx(void) GdkTool_SetToolBlock(GdkTool tool, kPxBlock toolBlock);

#endif
