/**
* @file    GdkOutputInfo.h
* @brief   Declares the GdkOutputInfo class.
*
* Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_OUTPUT_INFO_H
#define GDK_OUTPUT_INFO_H

#include <Gdk/GdkDef.h>
#include <Gdk/Config/GdkParamsInfo.h>

/**
* Describes a output type.
*
* @class       GdkOutputInfo
* @extends     kObject
* @ingroup     Gdk-Tools
*/
typedef kObject GdkOutputInfo;
kDeclareClassEx(Gdk, GdkOutputInfo, kObject)

/**
* Adds a new parameter to the output info object.
*
* @public               @memberof GdkOutputInfo
* @param    outputInfo  Output info object.
* @param    paramType   Parameter type to add. Should be one of the following:
*                       - #GDK_PARAM_TYPE_INT
*                       - #GDK_PARAM_TYPE_FLOAT
*                       - #GDK_PARAM_TYPE_BOOL
*                       - #GDK_PARAM_TYPE_PROFILE_REGION
*                       - #GDK_PARAM_TYPE_SURFACE_REGION
*                       - #GDK_PARAM_TYPE_SURFACE_REGION_2D
* @param    name        Parameter name.
* @param    label       Parameter label; same as name if kNULL.
* @param    defValue    Pointer to default value to set (depends on paramType).
* @param    paramInfo   Pointer to receive the newly added param info object.
* @return               Operation status.
*/
GdkFx(kStatus) GdkOutputInfo_AddParam(GdkOutputInfo outputInfo, GdkParamType paramType, const kChar* name, const kChar* label, void *defValue, GdkParamInfo *paramInfo);

#include <Gdk/Tools/GdkOutputInfo.x.h>

#endif
