/**
* @file     GdkGraphicPlane.x.h
*
* @internal
* Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_PLANE_X_H
#define GDK_GRAPHIC_PLANE_X_H

#include <kApi/Data/kMath.h>
#include <kApi/Data/kArrayList.h>

#include <Gdk/GdkDef.h>

typedef struct GdkGraphicPlaneClass
{
    kObjectClass base;
    kPoint3d32f normal;
    k32f distance; //distance to origin
} GdkGraphicPlaneClass;

kDeclareClassEx(Gdk, GdkGraphicPlane,kObject)

#define GdkGraphicPlaneTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphicPlane))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphicPlane_Init(GdkGraphicPlane graphic, kType classType, kAlloc allocator);
GdkFx(kStatus) GdkGraphicPlane_Release(GdkGraphicPlane graphic);

GdkFx(kStatus) GdkGraphicPlane_VRelease(GdkGraphicPlane graphic);
GdkFx(kStatus) GdkGraphicPlane_Serialize(GdkGraphicPlane graphic, kSerializer serializer);

#endif
