/**
* @file    GdkParams.h
* @brief   Declares the GdkParams class.
*
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_EXT_PARAMS_H
#define GDK_EXT_PARAMS_H

#include <Gdk/GdkDef.h>
#include <Gdk/Config/GdkParam.h>
#include <Gdk/Config/GdkParamsInfo.h>

/**
* Represents a set of parameters.
*
* @class       GdkParams
* @ingroup     Gdk-Config
*/
typedef kPointer GdkParams;

/**
* Returns the number of parameters in the set.
*
* @public               @memberof GdkParams
* @param    params      Params object.
* @return               Parameter Count.
*/
GdkFx(kSize) GdkParams_Count(GdkParams params);

/**
* Returns the parameter at a specified index.
*
* @public               @memberof GdkParams
* @param    params      Params object.
* @param    index       Index of parameter to get.
* @return               Paramter object.
*/
GdkFx(GdkParam) GdkParams_At(GdkParams params, kSize index);

/**
* Returns the parameter with a specified name.
*
* @public               @memberof GdkParams
* @param    params      Params object.
* @param    name        Name of the parameter to get.
* @return               Paramter object.
*/
GdkFx(GdkParam) GdkParams_Find(GdkParams params, const kChar* name);

#endif 
