#ifndef GDK_EXT_PARAM_Z_H
#define GDK_EXT_PARAM_Z_H

#include <Gdk/Config/GdkParam.h>

GdkFx(GdkParamInfo) GdkParam_Info(GdkParam param);

/**
* Sets the value of a geometric feature parameter.
*
* @public               @memberof GdkParam
* @param    param       Param object.
* @param    value       New parameter value.
* @return               Operation status.
*/
GdkFx(kStatus) GdkParam_SetGeometricFeature(GdkParam param, GdkGeometricFeatureId value);
GdkFx(GdkGeometricFeatureId) GdkParam_AsGeometricFeature(GdkParam param);

GdkFx(kStatus) GdkParam_SetInputStream(GdkParam param, GdkStreamId value);
GdkFx(GdkStreamId) GdkParam_InputStream(GdkParam param);

#endif
